#define BASE_FREQ 292800

#define POT_CS    5
#define POT_SCK   6
#define POT_SI    7

#define DDS_CLOCK  8
#define DDS_LOAD   9
#define DDS_DATA   10
#define DDS_RESET  11

#define ANALOG_REFE1 A3
#define ANALOG_AMPL1 A2
#define ANALOG_PHAS1 A1

int flag_1 = 1;
int flag_2 = 1;

float amp = 1024.0;
float phi = 1024.0;

float kr1 = 1024.0;
float kp1 = 1024.0;
float ka1 = 1024.0;

float pi = 3.141592;

int pot = 192800;

int ByteReceived = 1;

void setup()
{
  Serial.begin(115200);
  
  pinMode (DDS_CLOCK, OUTPUT);
  pinMode (DDS_LOAD,  OUTPUT);
  pinMode (DDS_DATA,  OUTPUT);
  pinMode (DDS_RESET, OUTPUT);

  pinMode (POT_CS,   OUTPUT);
  pinMode (POT_SCK,  OUTPUT);
  pinMode (POT_SI,   OUTPUT);
  
  analogRead(12);
  
  digitalWrite(DDS_RESET, HIGH);
  digitalWrite(DDS_RESET, LOW);
  
  digitalWrite(DDS_CLOCK, HIGH);
  digitalWrite(DDS_CLOCK, LOW);
  
  digitalWrite(DDS_LOAD, HIGH);
  digitalWrite(DDS_LOAD, LOW);
}

void loop()
{ 
  ByteReceived = Serial.read();
  if(ByteReceived == '1')
  {
    flag_1 = 1;
  }
  if (flag_1 == 1)
  {
    for(int j=1; j<2; j+=1)
    {
      for(int i=0; i<32; i+=1)
      {
        if (flag_2 == 1)
        {
          for (int k=0; k < i*2+64; k+=1)
          {
            sendPotentiometer(int(8.0*(i*i*(log(i*k+32.0))/sqrt(i*k+32.0))+16.0*i*log(k+128.0)/sqrt(i*k+2.0)));
            sendFrequency(int(BASE_FREQ*256.0*((1+sqrt(i+2.681/4.0*k))/(i+1.0))/log(i+2.681/4.0*k)));
            read_input();
            delayMicroseconds(60);
            Serial.println(i);
            Serial.println(k);
            Serial.println(amp,0);
            Serial.println(phi,0);
            if (k > 124)
            {
              flag_2 = 0;
            }
            if (k < 124)
            {
              flag_2 = 1;
            }
        }
        delayMicroseconds(120);
        flag_2 = 1;
        }
      }
    }
  }
  flag_1 = 1;
}

void read_input()
{
  kr1 = (float) (analogRead(ANALOG_REFE1));
  ka1 = (float) (analogRead(ANALOG_AMPL1));
  kp1 = (float) (analogRead(ANALOG_PHAS1));

  amp = (int) (4096.0*0.5/sqrt(pi/2.0)*(ka1/kr1));
  phi = (int) (4096.0*0.4831*(kp1/kr1));
}

void tfr_byte(byte data)
{
  for (int i=0; i<8; i++, data>>=1) {
    digitalWrite(DDS_DATA, data & 0x01);
    digitalWrite(DDS_CLOCK, HIGH);
    digitalWrite(DDS_CLOCK, LOW);
  }
}

void pot_byte(byte data)
{
  for (int i=0; i<8; i++, data>>=1) {
    digitalWrite(POT_SI, data & 0x01);
    digitalWrite(POT_SCK, HIGH);
    digitalWrite(POT_SCK, LOW);
  }
}

void sendFrequency(double frequency) {
  digitalWrite(DDS_LOAD, LOW);
  int32_t freq = frequency * 4294967295/125000000;  // 125 MHz clock on 9850
  for (int b=0; b<4; b++, freq>>=8) {
    tfr_byte(freq & 0xFF);
  }
  tfr_byte(0x000);
  digitalWrite(DDS_LOAD, HIGH);
  digitalWrite(DDS_LOAD, LOW);
}

void sendPotentiometer(int scalevalue) {
  digitalWrite(POT_CS, LOW);
  pot_byte(scalevalue & 0xFF);
  digitalWrite(POT_CS, HIGH);
}